<?php

namespace Netzperfekt\QRCodeGenerator\Enums;

enum QRCodeErrorCorrection: string
{
    case Low      = 'L';
    case Medium   = 'M';
    case Quartile = 'Q';
    case High     = 'H';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Low      => __('enums.errorcorrection.low.label'),
            self::Medium   => __('enums.errorcorrection.medium.label'),
            self::Quartile => __('enums.errorcorrection.quartile.label'),
            self::High     => __('enums.errorcorrection.high.label'),
        };
    }
}
