<x-filament-widgets::widget class="fi-account-widget">
    <x-filament::section>
        <div class="flex items-center gap-x-3 h-24">

            <div class="flex-1">
                <h2 class="grid flex-1 text-base font-semibold leading-6 text-gray-950 dark:text-white">
                    <a href="{{ $settingsResourceUrl }}" class="hover:underline">
                        <x-filament::icon icon="heroicon-o-cog" class="h-5 w-5 inline" />
                        {{ config('app.name') }} | Settings
                    </a>
                </h2>

                <div class="text-sm text-gray-500 dark:text-gray-400 mt-2 flex inline-block">
                    @foreach($settings as $key => $field)
                         <span class="mr-2 font-semibold">
                            {{ $field['label'] }}:
                         </span>
                         <x-filament::badge class="mr-6">
                             @if($field['type'] == 'bool')
                                 {{ $field['value'] ? 'AN' : 'AUS' }}
                             @else
                                 {{ $field['value'] }}
                             @endif
                        </x-filament::badge>
                    @endforeach
                </div>
            </div>
        </div>
    </x-filament::section>
</x-filament-widgets::widget>
