<?php

namespace Netzperfekt\SaasBase\Controllers;

use Illuminate\Http\Request;
use Netzperfekt\SaasBase\Events\GetSitemapEvent;

class SitemapController extends Controller
{
    // https://github.com/LaraPalCom/laravel-sitemap

    public function sitemap(Request $request)
    {
        $sitemap = resolve("sitemap");

        $sitemapsFromPackages = array_filter(GetSitemapEvent::dispatch());
        foreach($sitemapsFromPackages as $packages)
        {
            foreach($packages as $sitemapEntry)
            {
                // TODO maybe DTO here
                $sitemap->add(
                    $sitemapEntry['route'],
                    $sitemapEntry['updated_at'],
                    'daily');
            }
        }

        return $sitemap->render('xml');
    }
}
