<?php

namespace Netzperfekt\SaasBase;

use Filament\Events\TenantSet;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Logout;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Netzperfekt\SaasBase\Listeners\RememberTenant;
use Netzperfekt\SaasBase\Listeners\UserLoggedIn;
use Netzperfekt\SaasBase\Listeners\UserLoggedOut;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        Login::class => [
            UserLoggedIn::class
        ],
        Logout::class => [
            UserLoggedOut::class
        ],
        TenantSet::class => [
            RememberTenant::class
        ]
    ];

    public function boot(): void
    {
        //
    }

    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
