<?php

namespace Netzperfekt\SaasBase\Filament\Classes;

use Filament\AvatarProviders\Contracts\AvatarProvider;
use Filament\AvatarProviders\UiAvatarsProvider;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Netzperfekt\SaasBase\Models\User;

class GravatarsProvider implements AvatarProvider
{
    public function get(Model | Authenticatable $record): string
    {
        if($record instanceof User)
        {
            $hash = md5(strtolower(trim($record->email)));

            return "https://www.gravatar.com/avatar/{$hash}.jpg";
        }

        $uiAvatars = new UiAvatarsProvider();
        return $uiAvatars->get($record);
    }
}
