<?php

namespace Netzperfekt\SaasBase\Filament\Pages\Auth;

use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\Auth\EditProfile as BaseEditProfile;
use Illuminate\Support\Arr;
use Netzperfekt\SaasBase\Events\GetProfileFieldsEvent;
use Netzperfekt\SaasBase\Models\UserType;
use Tapp\FilamentTimezoneField\Forms\Components\TimezoneSelect;

class EditProfile extends BaseEditProfile
{
    public function form(Form $form): Form
    {
        $additionalFields = event(new GetProfileFieldsEvent());
        $additionalFields = Arr::flatten(array_filter($additionalFields));

        return $form
            ->schema([
                $this->getNameFormComponent(),
                $this->getEmailFormComponent(),
                $this->getPasswordFormComponent(),
                $this->getPasswordConfirmationFormComponent(),

                ...$this->getProfileFields(),
                ...$additionalFields
            ]);
    }

    private function getProfileFields(): array
    {
        return [
            Select::make('usertype_id')
                ->label(__('audience'))
                ->required()
                ->options(UserType::active()->pluck('title', 'id')),

            TimezoneSelect::make('timezone')
                ->label(__('timezone'))
                ->default(config('saas-base.user_default_timezone'))
                ->searchable()
                ->required(),

            Grid::make(2)
            ->schema([
                Toggle::make('newsletter')
                    ->label(__('newsletter')),

                Toggle::make('superadmin')
                    ->label(__('super-admin'))
                    ->hidden(! auth()?->user()?->isSuperAdmin() ?? false)
                    ->disabled(),
            ])
        ];
    }

    protected function afterSave()
    {
        session(['user_timezone' => validateTimezone($this->data['timezone'])]);
    }
}
