<?php

namespace Netzperfekt\SaasBase\Filament\Pages\Auth;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Pages\Auth\Register as BaseRegister;
use Illuminate\Support\Arr;
use Netzperfekt\SaasBase\Events\GetProfileFieldsEvent;
use Netzperfekt\SaasBase\Models\UserType;
use Tapp\FilamentTimezoneField\Forms\Components\TimezoneSelect;

class Register extends BaseRegister
{
    protected function getForms(): array
    {
        $additionalFields = event(new GetProfileFieldsEvent());
        $additionalFields = Arr::flatten(array_filter($additionalFields));

        return [
            'form' => $this->form(
                $this->makeForm()
                    ->schema([
                        $this->getNameFormComponent(),
                        $this->getEmailFormComponent(),
                        $this->getPasswordFormComponent(),
                        $this->getPasswordConfirmationFormComponent(),

                        ...$this->getProfileFields(),
                        ...$additionalFields
                    ])
                    ->statePath('data'),
            ),
        ];
    }

    private function getProfileFields(): array
    {
        return [
            TimezoneSelect::make('timezone')
                ->label(__('timezone'))
                ->default(config('saas-base.user_default_timezone'))
                ->searchable()
                ->required(),

            Toggle::make('superadmin')
                ->label(__('super-admin'))
                ->hidden(! auth()?->user()?->isSuperAdmin() ?? false)
                ->disabled(),

            Select::make('usertype_id')
                ->label(__('audience'))
                ->required()
                ->options(UserType::active()->pluck('title', 'id'))
                ->hidden(auth()?->user()?->isSuperAdmin() ?? false),

            Toggle::make('newsletter')
                ->label(__('newsletter'))
                ->hidden(auth()?->user()?->isSuperAdmin() ?? false)
        ];
    }
}
