<?php

namespace Netzperfekt\SaasBase\Filament\Pages;

use Filament\Actions\Action;
use Filament\Forms\Components\MarkdownEditor;
use Filament\Forms\Components\Tabs;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Resources\Components\Tab;
use Filament\Support\Exceptions\Halt;
use Illuminate\Support\Facades\Auth;
use Netzperfekt\SaasBase\Events\GetSettingsFieldsEvent;
use Netzperfekt\SaasBase\Models\Settings as SettingsModel;

class Changelog extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-bottom-center-text';
    protected static string $view = 'saas-base::filament.pages.changelog';
    protected static ?int $navigationSort = 0;

    private const FILE_CHANGELOG = 'changelog.md';

    public ?array $data = [];

    protected function getActions(): array
    {
        return [];
    }

    protected function getFormActions(): array
    {
        return [];
    }

    protected function getFormStatePath(): string
    {
        return 'data';
    }

    protected function getFormSchema(): array
    {
        return [
            MarkdownEditor::make('changelog')
                ->label(__('changes'))
                ->toolbarButtons([])
                ->disabled()
        ];
    }

    public function mount(): void
    {
        $changeLogFileName = base_path() . '/' . self::FILE_CHANGELOG;
        if(file_exists($changeLogFileName))
        {
            $content = file_get_contents($changeLogFileName);
        }

        $formValues = ['changelog' => $content ?? ''];

        $this->form->fill($formValues);
    }

    public static function getNavigationLabel(): string
    {
        return __(config('saas-base.changelog_label'));
    }

    public function getTitle(): string
    {
        return __(config("saas-base.changelog_label"));
    }
}
