<?php

namespace Netzperfekt\SaasBase\Filament\Pages\Tenancy;

use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Tenancy\EditTenantProfile;
use Illuminate\Support\Arr;
use Netzperfekt\SaasBase\Events\GetTeamProfileFieldsEvent;
use Netzperfekt\SaasBase\SaasBase;
use RalphJSmit\Filament\MediaLibrary\Forms\Components\MediaPicker;

class EditTeamProfile extends EditTenantProfile
{
    final public const DEFAULT_COLOR_BACKGROUND = '#FFFFFF';
    final public const DEFAULT_COLOR_TEXT       = '#000000';
    final public const DEFAULT_COLOR_HIGHLIGHT  = '#0000FF';

    public static function getLabel(): string
    {
        return __('team-profile');
    }

    public function form(Form $form): Form
    {
        $baseProfileFields = $this->getBaseProfileFields();
        $brandingProfileFields = $this->getBrandingProfileFields();

        $additionalFields = event(new GetTeamProfileFieldsEvent(baseFields: $baseProfileFields));
        $additionalFields = Arr::flatten(array_filter($additionalFields));

        return $form
            ->schema([
                Section::make(__('team-profile'))
                    ->schema($baseProfileFields),

                Section::make('Farben / CI')
                    ->columns(6)
                    ->description('Die Angaben in diesem Bereich werden als Standard-Einstellungen für neue QR-Codes und Landingpages übernommen und können dort dann noch angepasst werden.')
                    ->schema($brandingProfileFields),

                ...$additionalFields
            ]);
    }

    private function getBaseProfileFields()
    {
        return [
            Grid::make()
                ->columns(4)
                ->schema([
                    TextInput::make('name')
                        ->label(__('team-name')),
                    TextInput::make('company')
                        ->label(__('company')),
                    TextInput::make('address1')
                        ->label(__('address1')),
                    TextInput::make('address2')
                        ->label(__('address2')),
                ]),

            Grid::make()
                ->columns(16)
                ->schema([
                    TextInput::make('zip')
                        ->label(__('zip'))
                        ->columnSpan(2),

                    TextInput::make('city')
                        ->label(__('city'))
                        ->columnSpan(3),

                    Select::make('country')
                        ->label(__('country'))
                        ->options(SaasBase::getCountryOptions())
                        ->placeholder('---')
                        ->columnSpan(3)
                ])

            /*
            TextInput::make('options.slogan')
                ->label(__('slogan'))
            */
        ];
    }

    private function getBrandingProfileFields()
    {
        return [
            ColorPicker::make('options.color_background')
                ->label(__('color-background'))
                ->columnSpan(1),

            ColorPicker::make('options.color_text')
                ->label(__('color-text'))
                ->columnSpan(1),

            ColorPicker::make('options.color_highlight')
                ->label(__('color-highlight'))
                ->columnSpan(1),

            MediaPicker::make('options.logo')
                ->label(__('logo'))
                ->acceptedFileTypes(['application/pdf', 'image/jpeg', 'image/png', 'image/svg+xml'])
                ->columnSpan(1)
        ];
    }

    protected function afterFill(): void
    {
        if( ! $this->data['options']['color_background'])
        {
            $this->data['options']['color_background'] = self::DEFAULT_COLOR_BACKGROUND;
        }

        if( ! $this->data['options']['color_text'])
        {
            $this->data['options']['color_text'] = self::DEFAULT_COLOR_TEXT;
        }

        if( ! $this->data['options']['color_highlight'])
        {
            $this->data['options']['color_highlight'] = self::DEFAULT_COLOR_HIGHLIGHT;
        }

        event(new GetTeamProfileFieldsEvent($this));
    }
}
