<?php

namespace Netzperfekt\SaasBase\Filament\Pages\Tenancy;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Tenancy\RegisterTenant;
use Netzperfekt\SaasBase\Models\Team;

class RegisterTeam extends RegisterTenant
{
    public static function getLabel(): string
    {
        return __('register_new_company');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('team-name'))
                    ->default(auth()->user()->name ?? '')
                    ->required(),

                TextInput::make('company')
                    ->label(__('company'))
            ]);
    }

    protected function handleRegistration(array $data): Team
    {
        $team = Team::create($data);

        $team->members()->attach(auth()->user());

        return $team;
    }

    public static function canView(): bool
    {
        if(auth()->user()->teams()->count() >= 1) {
            return false;
        }

        return parent::canView();
    }
}
