<?php

namespace Netzperfekt\SaasBase\Filament\Resources\UserResource\Pages;

use Carbon\Carbon;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Netzperfekt\SaasBase\Filament\Resources\UserResource\UserResource;
use Netzperfekt\SaasBase\Traits\HasCreatePageActions;

class CreateUser extends CreateRecord
{
    use HasCreatePageActions;

    protected static string $resource = UserResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['password'] = Hash::make('changeme_' . Str::random(16));
        $data['email_verified_at'] = Carbon::now();

        return $data;
    }

    protected function afterCreate(): void
    {
        if($this->record->superadmin)
        {
            $this->record->teams()->attach(auth()->user()->getCurrentTeamId());
            $this->record->save();
        }
    }
}
