<?php

namespace Netzperfekt\SaasBase\Filament\Resources\UserResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Netzperfekt\SaasBase\Filament\Resources\UserResource\UserResource;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use STS\FilamentImpersonate\Pages\Actions\Impersonate;

class EditUser extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Impersonate::make()->record($this->getRecord())->redirectTo(route('filament.app.tenant')),
            Actions\DeleteAction::make()
        ];
    }
}
