<?php

namespace Netzperfekt\SaasBase\Filament\Resources\UserTypeResource;

use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Support\Enums\IconSize;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Support\Arr;
use Netzperfekt\SaasBase\Events\GetUserTypesOptionsFieldsEvent;
use Netzperfekt\SaasBase\Filament\Resources\UserTypeResource\Pages\CreateUserType;
use Netzperfekt\SaasBase\Filament\Resources\UserTypeResource\Pages\EditUserType;
use Netzperfekt\SaasBase\Filament\Resources\UserTypeResource\Pages\ListUserTypes;
use Netzperfekt\SaasBase\Models\UserType;

class UserTypeResource extends Resource
{
    protected static ?string $model = UserType::class;
    protected static ?string $recordTitleAttribute = 'title';
    protected static bool $isScopedToTenant = false;

    protected static ?string $navigationIcon = 'heroicon-o-user-circle';
    protected static ?int $navigationSort = 4;

    public static function getNavigationGroup(): ?string
    {
        return __('user-navigation-group');
    }

    public static function getModelLabel(): string
    {
        return __('user-type');
    }

    public static function getPluralModelLabel(): string
    {
        return __('user-types');
    }

    public static function form(Form $form): Form
    {
        $additionalOptionFields = event(new GetUserTypesOptionsFieldsEvent($form));
        $additionalOptionFields = Arr::flatten(array_filter($additionalOptionFields));

        return $form
            ->columns(3)
            ->schema([
                Section::make('Benutzerdaten')
                    ->columnSpan(2)
                    ->columns(3)
                    ->schema([
                        TextInput::make('key')
                            ->label(__('key'))
                            ->required()
                            ->columnSpan(1),

                        TextInput::make('title')
                            ->label(__('title'))
                            ->required()
                            ->columnSpan(2)
                    ]),

                Section::make('Optionen')
                    ->columnSpan(1)
                    ->schema([
                        Toggle::make('is_active')
                            ->label(__('active'))
                            ->onColor('success')
                            ->offColor('danger')
                            ->default(true),

                        ...$additionalOptionFields
                    ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('key')
                    ->label(__('key'))
                    ->sortable(),

                Tables\Columns\TextColumn::make('title')
                    ->label(__('title')),

                Tables\Columns\TextColumn::make('qrcode_types')
                    ->label(__('qrcodes'))
                    ->badge(),

                Tables\Columns\ToggleColumn::make('is_active')
                    ->label(__('active'))
                    ->disabled()
                    ->onColor('success')
                    ->offColor('danger')
                    ->sortable()
            ])

            ->filters([
                //
            ])

            ->actions([
                Tables\Actions\EditAction::make()
                    ->label('')
                    ->tooltip(__('edit'))
                    ->iconSize(IconSize::Medium),

                Tables\Actions\DeleteAction::make()
                    ->label('')
                    ->tooltip(__('delete'))
                    ->iconSize(IconSize::Medium)
            ])

            ->bulkActions([
            ])

            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListUserTypes::route('/'),
            'create' => CreateUserType::route('/create'),
            'edit' => EditUserType::route('/{record}/edit'),
        ];
    }
}
