<?php

namespace Netzperfekt\SaasBase\Filament\Widgets;

use Filament\Widgets\Widget;
use Netzperfekt\SaasBase\Filament\Pages\Settings;
use Netzperfekt\SaasBase\Models\Settings as SettingsModel;
use Netzperfekt\SaasBase\SaasBase;

class SaasSettingsWidget extends Widget
{
    protected static ?int $sort = -1;

    protected static bool $isLazy = false;

    protected static string $view = SaasBase::PACKAGE_NAME . '::filament.widgets.settings-info';
    protected int | string | array $columnSpan = 'full';

    public array $settings = [];
    public string $settingsResourceUrl = '';

    public static function canView(): bool
    {
        $settingsFields = array_filter(array_map(fn($f) => $f['widget'] ?? [], Settings::collectSettingsFields()));

        return count($settingsFields) > 0;
    }

    public function __construct()
    {
        $this->settingsResourceUrl = Settings::getUrl();

        $settingsFields = array_filter(array_map(fn($f) => $f['widget'] ?? [], Settings::collectSettingsFields()));

        foreach($settingsFields as $field)
        {
            foreach(array_keys($field) as $key)
            {
                $value = SettingsModel::get($key);
                $field[$key]['value'] = $value;
            }

            $this->settings = array_merge($this->settings, $field);
        }
    }
}
