<?php

namespace Netzperfekt\SaasBase\Listeners;

use Carbon\Carbon;

class UserLoggedIn
{
    public function handle(object $event): void
    {
        $user = $event->user;
        $user->last_login = Carbon::now();
        $user->save();

        session(['user_timezone' => validateTimezone($user->timezone)]);

        activity()->causedBy($user)->log('login');
    }
}
