<?php

namespace Netzperfekt\SaasBase\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckBanned
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check() && ! auth()->user()->isActive())
        {
            auth()->logout();

            return redirect()->route('filament.app.auth.login');
        }

        return $next($request);
    }
}
