<?php

namespace Netzperfekt\SaasBase\Models;

use Database\Factories\SettingsFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Settings extends Model
{
    use HasFactory;

    // --- dont --- use LogsActivity;
    // not logged in model - primary key is string, spatie/activitylog will not work with this
    // instead it is logged in filament resource

    protected $primaryKey = 'key';
    public $incrementing = false;

    public $fillable = ['key', 'value'];

    protected $casts = ['value' => 'json'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->setTable(config('saas-base.settings_tablename'));
    }

    public function setValueAttribute(string|\JsonSerializable $value)
    {
        $this->attributes['value'] = is_array($value) || $value instanceof \JsonSerializable
            ? json_encode($value)
            : $value;
    }

    public function getValueAttribute($value)
    {
        return $value;
    }

    public static function get(string $key, $default = null): string|object|null
    {
        $setting = Settings
            ::where('key', $key)
            ->first();

        return $setting ? json_decode($setting?->value) : $default;
    }

    protected static function newFactory(): Factory
    {
        return SettingsFactory::new();
    }
}
