<?php

namespace Netzperfekt\SaasBase\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;

class UserType extends Model
{
    use HasGlobalModelObserver;
    use LogsActivity;

    protected $table = 'user_types';

    protected $fillable = [
        'key', 'title', 'qrcode_types', 'is_active'
    ];

    const DEFAULT_USERTYPE_KEY = 'default';

    public function getCasts(): array
    {
        if(config('saas-base.casts_usertype'))
        {
            return [
                'qrcode_types' => config('saas-base.casts_usertype')
            ];
        }

        return [];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('is_active', true);
    }

    public static function getDefault(): UserType
    {
        return UserType::where('key', '=', self::DEFAULT_USERTYPE_KEY)->first();
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()->logFillable();
    }
}
