<?php

namespace Netzperfekt\SaasBase\Observers;

use Illuminate\Database\Eloquent\Model;

class GlobalModelObserver
{
    // implies creating + updating
    public function saving(Model $model)
    {
        // ensure teamId is set
        if($model->isFillable('team_id') && ! $model->team_id)
        {
            $model->team_id = filament()->getTenant()?->getKey() ?? 0;
        }
    }
}
