<?php

namespace Netzperfekt\SaasBase\Traits;

use Filament\Actions\Action;

trait HasCreatePageActions
{
    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),

            Action::make('create')
                ->label(__('save_and_back'))
                ->color('success')
                ->action(function() {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                }),

            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),

            $this->getCancelFormAction(),
        ];
    }
}
