<?php

namespace Netzperfekt\SaasBase\Traits;

use Filament\Facades\Filament;
use Illuminate\Database\Eloquent\Builder;

trait HasDefaultScopes
{
    public function scopeOnlyMyRecords(Builder $query): void
    {
        // TODO besser? $teamIds = Auth()->user()->teams()->pluck('team_id')->toArray();

        // oder nur die aktuelle TeamId?
        $teamIds = [Filament::getTenant()->id];

        $query->whereIn('team_id', $teamIds);
    }
}
