<?php

if (! function_exists('validateTimezone'))
{
    function validateTimezone(?string $timezone): string
    {
        $timezone = empty($timezone) ? config('saas-base.user_default_timezone') : $timezone;

        if(! in_array($timezone, timezone_identifiers_list()))
        {
            $timezone = config('saas-base.user_default_timezone');
        }

        return $timezone;
    }
}

if (! function_exists('setting'))
{
    function setting(string $key, $default = null): string|object
    {
        return \Netzperfekt\SaasBase\Models\Settings::get($key, $default) ?? '';
    }
}
