<nav class="navbar navbar-light navbar-expand-lg py-5 py-lg-3">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold" href="/">
            <img class="img-fluid brand-logo" src="{{ asset('img/logo.svg') }}" alt="{{ setting('settings-cms-brand') ?: config('app.name') }}">
            <span class="brand-name">{{ setting('settings-cms-brand') ?: config('app.name') }}</span>
        </a>

        <button class="navbar-toggler" type="button"
                data-bs-toggle="collapse" data-bs-target="#navbarHeader"
                aria-controls="navbarHeader" aria-expanded="false" aria-label="Navigation anzeigen">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse justify-content-center" id="navbarHeader">
            <ul class="navbar-nav mx-auto">
                @foreach($navigation as $itemLabel => $item)
                    @if($item['type'] != 'action')
                        @if(count($item['children']) > 0)
                            <li class="nav-item p-3 dropdown">
                                <a class="nav-link p-0 dropdown-toggle" href="#"
                                   data-bs-toggle="dropdown" aria-expanded="false">
                                    {{ $itemLabel }}
                                </a>
                                <ul class="dropdown-menu dropdown-menu">
                                    @foreach($item['children'] as $childrenLabel => $childrenItem)
                                        <li>
                                            <a class="dropdown-item {{ \Illuminate\Support\Facades\Request::is('*/' . ($childrenItem['cmspage']['slug'] ?? '')) ? 'fw-bold' : '' }}"
                                               href="{{ $childrenItem['url'] }}">{{ $childrenLabel }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            </li>
                        @else
                            <li class="nav-item p-3">
                                <a class="nav-link p-0 {{ \Illuminate\Support\Facades\Request::is('*/' . ($item['cmspage']['slug'] ?? '')) ? 'fw-bold' : '' }}"
                                   href="{{ $item['url'] }}">{{ $itemLabel }}</a>
                            </li>
                        @endif
                    @endif
                @endforeach
            </ul>

            <ul class="navbar-nav">
                @foreach($navigation as $itemLabel => $item)
                    @if($item['type'] == 'action' && $item['enabled'])
                        <span class="nav-item p-3">
                            <a class="btn btn-sm @if($item['action'] == 'register') btn-warning @else btn-info @endif" href="{{ $item['url'] }}">{{ $itemLabel }}</a>
                        </span>
                    @endif
                @endforeach
            </ul>
        </div>
    </div>
</nav>
