<?php

namespace Netzperfekt\SaasCms\Data;

use Livewire\Wireable;
use Netzperfekt\SaasCms\Models\CmsPage;
use Netzperfekt\SaasCms\Models\CmsTemplate;
use Spatie\LaravelData\Concerns\WireableData;
use Spatie\LaravelData\Data;

class CmsPageData extends Data implements Wireable
{
    use WireableData;

    public function __construct
    (
        public ?CmsPage $page = null,
        public ?CmsTemplate $template = null,
        public ?object $fields = null,

        public ?string $slug = '',
        public ?string $title = '',
        public ?string $seoTitle = '',
        public ?string $seoDescription = ''
    ) { }
}
