<?php

namespace Netzperfekt\SaasCms\Enums;

use Faker\Factory;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Support\Contracts\HasLabel;
use RalphJSmit\Filament\MediaLibrary\Forms\Components\MediaPicker;

enum FieldType: string implements HasLabel
{
    case Text        = 'text';
    case TextArea    = 'textarea';
    case Link        = 'link';
    case InfoBlock   = 'infoblock';
    case TextEditor  = 'editor';
    case Color       = 'color';
    case File        = 'file';
    case Faq         = 'faq';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Text       => __('cms-field-type-text'),
            self::TextArea   => __('cms-field-type-textarea'),
            self::Link       => __('cms-field-type-link'),
            self::InfoBlock  => __('cms-field-type-infoblock'),
            self::TextEditor => __('cms-field-type-editor'),
            self::Color      => __('cms-field-type-color'),
            self::File       => __('cms-field-type-file'),
            self::Faq        => __('cms-field-type-faq'),
        };
    }

    public function getFormComponent(): ?string
    {
        return match ($this) {
            self::Text       => TextInput::class,
            self::TextArea   => Textarea::class,
            self::Link       => Section::class,
            self::InfoBlock  => Section::class,
            self::TextEditor => RichEditor::class,
            self::Color      => ColorPicker::class,
            self::File       => MediaPicker::class,
            self::Faq        => Section::class,
        };
    }

    public function getDummyContent(): string|array
    {
        $faker = Factory::create();

        return match ($this) {
            self::Text       => $faker->text(20),
            self::TextArea   => $faker->paragraph(),
            self::TextEditor => $faker->paragraph(),
            self::Link       => ['title' => $faker->paragraph(), 'url' => $faker->url(), 'openblank' => true],
            self::InfoBlock  => ['icon' => 'fas-info', 'title' => $faker->word(), 'text' => $faker->paragraph()],
            self::Color      => '#0000ff',
            self::File       => 'https://placehold.co/800x600',
            self::Faq        => ['faqgroup' => 0, 'template' => '']
        };
    }

    public function equals(string $s): bool
    {
        return $this->value === $s;
    }

    // TODO brauche ich vlt. gar nicht - dann wieder raus
    // lieber mit blade components arbeiten (z.b. für media)
    public function resolveValue($value)
    {
        return match ($this) {
            // self::File  => Media::resolveMediaFile($value),
            default     => $value ?? '',
        };
    }
}
