<?php

namespace Netzperfekt\SaasCms;

use Netzperfekt\SaasBase\Events\GetSettingsFieldsEvent;
use Netzperfekt\SaasBase\Events\GetSitemapEvent;
use Netzperfekt\SaasCms\Listeners\GetSettingsFields;
use Netzperfekt\SaasCms\Listeners\GetSitemapListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        GetSitemapEvent::class => [
            GetSitemapListener::class
        ],
        GetSettingsFieldsEvent::class => [
            GetSettingsFields::class
        ]
    ];

    public function boot(): void
    {
        //
    }

    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
