<?php

namespace Netzperfekt\SaasCms\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Netzperfekt\SaasCms\Enums\CmsLinkType;

class GetCmsLinkTypesEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(private readonly ?CmsLinkType $returnType = CmsLinkType::Fields)
    {
    }

    public function getReturnType()
    {
        return $this->returnType;
    }
}
