<?php

namespace Netzperfekt\SaasCms\Filament\Exporter;

use Filament\Actions\Exports\Enums\ExportFormat;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;
use Netzperfekt\SaasCms\Models\CmsPage;

class CmsPageExporter extends Exporter
{
    protected static ?string $model = CmsPage::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('template.title'),
            ExportColumn::make('is_active'),
            ExportColumn::make('is_homepage'),
            ExportColumn::make('title'),
            ExportColumn::make('slug'),
            ExportColumn::make('group'),
            ExportColumn::make('seo_title'),
            ExportColumn::make('seo_description'),
            ExportColumn::make('contents')->listAsJson()
        ];
    }

    public function getFormats(): array
    {
        return [
            ExportFormat::Csv,
        ];
    }

    public function getFileName(Export $export): string
    {
        return "cmspages-{$export->getKey()}";
    }

    public static function getCompletedNotificationTitle(Export $export): string
    {
        return 'Export CMS Seiten';
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Der Export wurde abgeschlossen, es wurden ' . number_format($export->successful_rows) . ' Einträge exportiert.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht exportiert werden.';
        }

        return $body;
    }
}
