<?php

namespace Netzperfekt\SaasCms\Filament\Exporter;

use Filament\Actions\Imports\ImportColumn;
use Filament\Actions\Imports\Importer;
use Filament\Actions\Imports\Models\Import;
use Netzperfekt\SaasCms\Models\CmsPage;

class CmsPageImporter extends Importer
{
    protected static ?string $model = CmsPage::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ImportColumn::make('template')
                ->validationAttribute('template')
                ->relationship('template', resolveUsing: 'title'),

            ImportColumn::make('is_active')
                ->validationAttribute('is_active')
                ->boolean(),

            ImportColumn::make('is_homepage')
                ->validationAttribute('is_homepage')
                ->boolean(),

            ImportColumn::make('title')
                ->validationAttribute('title'),

            ImportColumn::make('slug')
                ->validationAttribute('slug'),

            ImportColumn::make('group')
                ->validationAttribute('group'),

            ImportColumn::make('seo_title')
                ->validationAttribute('seo_title'),

            ImportColumn::make('seo_description')
                ->validationAttribute('seo_description'),

            ImportColumn::make('contents')
                ->validationAttribute('contents')
                ->castStateUsing(function (?string $state): ?array {
                    return json_decode($state ?? '', true);
                }),
        ];
    }

    public function resolveRecord(): ?CmsPage
    {
        return CmsPage::firstOrNew([
            'slug' => $this->data['slug'],
        ]);
    }

    public static function getCompletedNotificationTitle(Import $import): string
    {
        return 'Import CMS Seiten';
    }

    public static function getCompletedNotificationBody(Import $import): string
    {
        $body = 'Der Import wurde ausgeführt und ' . number_format($import->successful_rows) . ' Einträge wurden importiert.';

        if ($failedRowsCount = $import->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht importiert werden.';
        }

        return $body;
    }
}
