<?php

namespace Netzperfekt\SaasCms\Filament\Exporter;

use Filament\Actions\Imports\ImportColumn;
use Filament\Actions\Imports\Importer;
use Filament\Actions\Imports\Models\Import;
use Netzperfekt\SaasCms\Models\CmsTemplate;

class CmsTemplateImporter extends Importer
{
    protected static ?string $model = CmsTemplate::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ImportColumn::make('title')
                ->validationAttribute('title'),

            ImportColumn::make('description')
                ->validationAttribute('description'),

            ImportColumn::make('template')
                ->validationAttribute('template'),

            ImportColumn::make('template_type')
                ->validationAttribute('template_type'),

            ImportColumn::make('fields')
                ->validationAttribute('fields')
                ->castStateUsing(function (string $state): array {
                    return json_decode($state ?? '');
                }),
        ];
    }

    public function resolveRecord(): ?CmsTemplate
    {
        return CmsTemplate::firstOrNew([
            'template' => $this->data['template'],
        ]);
    }

    public static function getCompletedNotificationTitle(Import $import): string
    {
        return 'Import CMS Templates';
    }

    public static function getCompletedNotificationBody(Import $import): string
    {
        $body = 'Der Import wurde ausgeführt und ' . number_format($import->successful_rows) . ' Einträge wurden importiert.';

        if ($failedRowsCount = $import->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht importiert werden.';
        }

        return $body;
    }
}
