<?php

namespace Netzperfekt\SaasCms\Filament\Exporter;

use Filament\Actions\Exports\Enums\ExportFormat;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;
use Netzperfekt\SaasCms\Models\CmsTree;

class CmsTreeExporter extends Exporter
{
    protected static ?string $model = CmsTree::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('title'),
            ExportColumn::make('group'),
            ExportColumn::make('position'),
            ExportColumn::make('items')->listAsJson()
        ];
    }

    public function getFormats(): array
    {
        return [
            ExportFormat::Csv,
        ];
    }

    public function getFileName(Export $export): string
    {
        return "cmstrees-{$export->getKey()}";
    }

    public static function getCompletedNotificationTitle(Export $export): string
    {
        return 'Export CMS Seitenbäume';
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Der Export wurde abgeschlossen, es wurden ' . number_format($export->successful_rows) . ' Einträge exportiert.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht exportiert werden.';
        }

        return $body;
    }
}
