<?php

namespace Netzperfekt\SaasCms\Filament\Exporter;

use Filament\Actions\Imports\ImportColumn;
use Filament\Actions\Imports\Importer;
use Filament\Actions\Imports\Models\Import;
use Netzperfekt\SaasCms\Models\CmsTree;

class CmsTreeImporter extends Importer
{
    protected static ?string $model = CmsTree::class;

    public function getJobConnection(): ?string
    {
        return 'sync';
    }

    public static function getColumns(): array
    {
        return [
            ImportColumn::make('title')
                ->validationAttribute('title'),

            ImportColumn::make('group')
                ->validationAttribute('group'),

            ImportColumn::make('position')
                ->validationAttribute('position'),

            ImportColumn::make('items')
                ->validationAttribute('items')
                ->castStateUsing(function (?string $state): ?array {
                    return json_decode($state ?? '', true);
                }),
        ];
    }

    public function resolveRecord(): ?CmsTree
    {
        return CmsTree::firstOrNew([
            'title' => $this->data['title'],
        ]);
    }

    public static function getCompletedNotificationTitle(Import $import): string
    {
        return 'Import CMS Seitenbäume';
    }

    public static function getCompletedNotificationBody(Import $import): string
    {
        $body = 'Der Import wurde ausgeführt und ' . number_format($import->successful_rows) . ' Einträge wurden importiert.';

        if ($failedRowsCount = $import->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' Einträge konnten nicht importiert werden.';
        }

        return $body;
    }
}
