<?php

namespace Netzperfekt\SaasCms\Filament\Resources\CmsPageResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Support\Enums\ActionSize;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use Netzperfekt\SaasCms\Filament\Resources\CmsPageResource\CmsPageResource;

class EditCmsPage extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = CmsPageResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('preview')
                ->label(__('cms-preview'))
                ->icon('fas-bolt')
                ->size(ActionSize::Medium)
                ->color('info')
                ->url(fn($record) => $record->is_homepage ? route('cms.home') : route('cms.page', $record->slug))
                ->openUrlInNewTab()
                ->visible(fn($record) => $record->slug),

            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }
}
