<?php

namespace Netzperfekt\SaasCms\Filament\Resources\CmsTemplateResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Support\Enums\ActionSize;
use Netzperfekt\SaasBase\Traits\HasEditPageActions;
use Netzperfekt\SaasCms\Filament\Resources\CmsTemplateResource\CmsTemplateResource;

class EditCmsTemplate extends EditRecord
{
    use HasEditPageActions;

    protected static string $resource = CmsTemplateResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('preview')
                ->label(__('cms-preview'))
                ->icon('fas-bolt')
                ->size(ActionSize::Medium)
                ->color('info')
                ->url(fn($record) => route('cms.template', $record->id))
                ->openUrlInNewTab()
                ->visible(fn($record) => $record->template_type == CmsTemplateResource::TEMPLATE_TYPE_PAGE),

            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }
}
