<?php

namespace Netzperfekt\SaasCms\Listeners;

use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;

class GetSettingsFields
{
    public function handle($event): array
    {
        return [
            'label'  => __('settings-cms'),
            'sort'   => 1,
            'fields' => [
                TextInput::make('settings-cms-url-pattern')
                    ->label('URL-Pattern für CMS-Seiten')
                    ->required()
                    ->default(config('saas-cms.default-url-pattern')),

                TextInput::make('settings-cms-brand')
                    ->label('Firmenname')
                    ->default(config('app.name')),

                TextInput::make('settings-cms-copyright')
                    ->label('Copyright (im Footer)')
                    ->default(config('app.name')),

                Textarea::make('settings-cms-tracking')
                    ->label('Tracking-Code'),

                Section::make(__('cms-settings-section-alert'))
                    ->compact()
                    ->schema([
                        Grid::make(6)
                            ->schema([
                                Toggle::make('settings-cms-alert-show')
                                    ->inline(false)
                                    ->live()
                                    ->label(__('cms-settings-alert-show')),

                                TextInput::make('settings-cms-alert-text')
                                    ->label(__('cms-settings-alert-text'))
                                    ->columnSpan(3)
                                    ->disabled(fn($get) => ! $get('settings-cms-alert-show')),

                                Select::make('settings-cms-alert-type')
                                    ->label(__('cms-settings-alert-type'))
                                    ->columnSpan(1)
                                    ->disabled(fn($get) => ! $get('settings-cms-alert-show'))
                                    ->options([
                                        'primary' => __('cms-settings-alert-type-primary'),
                                        'success' => __('cms-settings-alert-type-success'),
                                        'warning' => __('cms-settings-alert-type-warning'),
                                        'danger' => __('cms-settings-alert-type-danger'),
                                        'info' => __('cms-settings-alert-type-info'),
                                    ])
                                    ->default('primary')
                                    ->selectablePlaceholder(false),

                                TextInput::make('settings-cms-alert-url')
                                    ->label(__('cms-settings-alert-url'))
                                    ->columnSpan(1)
                                    ->disabled(fn($get) => ! $get('settings-cms-alert-show')),
                            ])
                    ])
            ]
        ];
    }
}
