<?php

namespace Netzperfekt\SaasCms\Listeners;

use Netzperfekt\SaasBase\Events\GetSitemapEvent;
use Netzperfekt\SaasCms\Models\CmsPage;

class GetSitemapListener
{
    public function __construct()
    {
        //
    }

    // TODO hier müsste vermutlich noch irgendwie nach group und/oder positions unterschieden werden
    // TODO welche route wird dann verwendet?
    public function handle(GetSitemapEvent $event): array
    {
        $cmsPages = CmsPage::active()->orderBy('created_at', 'desc')->get();

        $entries = [];
        foreach ($cmsPages as $cmsPage)
        {
            $entries[] = [
                'route' => route('cms.page', [$cmsPage->slug]),
                'updated_at' => $cmsPage->updated_at
            ];
        }

        return $entries;
    }
}
