<?php

namespace Netzperfekt\SaasCms\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Netzperfekt\SaasBase\Models\Team;
use Netzperfekt\SaasBase\Traits\HasDefaultScopes;
use Netzperfekt\SaasBase\Traits\HasGlobalModelObserver;
use RalphJSmit\Filament\MediaLibrary\Media\Models\MediaLibraryItem;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class CmsPage extends Model implements HasMedia
{
    use InteractsWithMedia, SoftDeletes;
    use HasGlobalModelObserver;
    use HasDefaultScopes;

    protected $fillable = [
        'team_id',
        'template_id',
        'is_active',
        'is_homepage',
        'title',
        'slug',
        'group',
        'contents',
        'seo_title',
        'seo_description',
        'mainimage_id',
        'image_ids'
    ];

    protected $casts = [
        'contents' => 'array',
        'image_ids' => 'array'
    ];

    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function template(): BelongsTo
    {
        return $this->belongsTo(CmsTemplate::class);
    }

    public function thumbnail(): BelongsTo
    {
        return $this->belongsTo(MediaLibraryItem::class, 'mainimage_id');
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('is_active', true);
    }

    public function scopeHomepage(Builder $query): void
    {
        $query->where('is_homepage', true);
    }

    public function scopeWithSlug(Builder $query, string $slug): void
    {
        $query->where('slug', $slug);
    }
}
