<?php

namespace Netzperfekt\SaasCms;

use Filament\Contracts\Plugin;
use Filament\Panel;
use Filament\Support\Facades\FilamentView;
use Filament\View\PanelsRenderHook;
use Illuminate\View\View;
use Netzperfekt\SaasBase\Models\Settings;
use Netzperfekt\SaasCms\Filament\Resources\CmsPageResource\CmsPageResource;
use Netzperfekt\SaasCms\Filament\Resources\CmsTemplateResource\CmsTemplateResource;
use Netzperfekt\SaasCms\Filament\Resources\CmsTreeResource\CmsTreeResource;

class SaasCms implements Plugin
{
    public final const PACKAGE_NAME = 'saas-cms';

    protected bool $isEnabled = false;
    protected bool $forTenants = false;
    protected string $forTenantsPackage = '';

    public static function make(): SaasCms
    {
        return new SaasCms();
    }

    public function getId(): string
    {
        return self::PACKAGE_NAME;
    }

    public function register(Panel $panel): void
    {
        if($this->getIsEnabled())
        {
            $activeResources = [];
            if($this->getForTenants())
            {
                $activeResources = [
                    CmsPageResource::class
                ];
            }
            else
            {
                $activeResources = [
                    CmsPageResource::class,
                    CmsTemplateResource::class,
                    CmsTreeResource::class
                ];
            }

            $panel->resources($activeResources);
        }
    }

    public function boot(Panel $panel): void
    {
        $this->bootFilament();
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function isEnabled(bool $value): static
    {
        $this->isEnabled = $value;

        return $this;
    }

    public function getForTenants(): bool
    {
        return $this->forTenants;
    }

    public function getForTenantsPackage(): string
    {
        return $this->forTenantsPackage;
    }

    public function enableForTenantsInPackage(string $packageName): static
    {
        $this->forTenants = true;
        $this->forTenantsPackage = $packageName;

        return $this;
    }

    public static function get(): static
    {
        return filament(app(static::class)->getId());
    }

    private function bootFilament()
    {
        $showGlobalMessage = Settings::get('settings-cms-alert-show', false);
        if($showGlobalMessage)
        {
            FilamentView::registerRenderHook(
                PanelsRenderHook::PAGE_START,
                fn(): View => view('saas-cms::filament.global-message')
            );
        }
    }
}
