<?php

namespace Netzperfekt\SaasCms;

use Filament\Support\Assets\Css;
use Filament\Support\Assets\Js;
use Filament\Support\Facades\FilamentAsset;
use Illuminate\Support\Facades\Blade;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class SaasCmsServiceProvider extends PackageServiceProvider
{
    public function packageRegistered()
    {
        $this->app->register(EventServiceProvider::class);
    }

    public function packageBooted()
    {
        $this->addAssets();
        $this->registerComponents();
    }

    public function configurePackage(Package $package): void
    {
        $package
            ->name(SaasCms::PACKAGE_NAME)
            ->hasRoute('web')
            ->hasViews()
            ->hasConfigFile(['saas-cms', 'filament-tiptap-editor'])
            ->hasTranslations()

            ->hasMigrations([
                'create_cms_templates_table',
                'create_cms_pages_table',
                'create_cms_tree_table'
            ])

            ->hasInstallCommand(function(InstallCommand $command)
            {
                $command
                    ->publishAssets()
                    ->publishMigrations()
                    ->askToRunMigrations();
            });
    }

    private function addAssets()
    {
        FilamentAsset::register([
            Js::make('saas-cms-js', __DIR__ . '/../resources/dist/saas-cms.js'),
            Css::make('saas-cms-css', __DIR__ . '/../resources/dist/saas-cms.css'),
            Css::make('saas-cms-css-frontend', __DIR__ . '/../resources/dist/saas-cms-frontend.css'),
        ], 'netzperfekt/saas-cms');
    }

    private function registerComponents()
    {
        Blade::componentNamespace('Netzperfekt\\SaasCms\\View\\Components', 'cms');
    }
}
