<?php

namespace Netzperfekt\SaasCms\View\Components;

use Illuminate\View\Component;
use Netzperfekt\SaasCms\Models\CmsTree;

class Footer extends Component
{
    public array $navigation = [];

    public function __construct(public readonly string $position,
                                public readonly string $group = 'default',
                                public readonly string $class = '',
                                public readonly string $style = '')
    {
        $this->navigation = CmsTree::getNavigation($position, $group);
    }

    public function render()
    {
        return view('saas-cms::frontend.components.footer');
    }
}