<?php

namespace Netzperfekt\SaasCms\View\Components;

use Illuminate\View\Component;
use RalphJSmit\Filament\MediaLibrary\Media\Models\MediaLibraryItem;

class Media extends Component
{
    public string $mediaUrl = '';
    public string $mediaTitle = '';
    public string $mediaAltText = '';

    public function __construct(public readonly string|int|null $id,
                                public readonly string $class = '',
                                public readonly string $style = ''
    )
    {
        [$this->mediaUrl, $this->mediaTitle, $this->mediaAltText] = $this->resolveMediaFile($id);
    }

    public static function resolveMediaFile($mediaId): array // [$url, $title, $altText]
    {
        if(empty($mediaId))
        {
            return ['', '', ''];
        }

        $mediaLibraryItem = MediaLibraryItem::find((int)$mediaId);
        if($mediaLibraryItem)
        {
            return [
                $mediaLibraryItem->getItem()->getUrl() ?? '',
                $mediaLibraryItem->caption ?? '',
                $mediaLibraryItem->alt_text ?? ''
            ];
        }

        return ['', '', ''];
    }

    public function render()
    {
        return view('saas-cms::frontend.components.media');
    }
}