<?php

namespace Netzperfekt\SaasCms\View\Components;

use Illuminate\View\Component;
use Netzperfekt\SaasCms\Models\CmsTree;

class Navigation extends Component
{
    public array $navigation = [];

    public function __construct(public readonly string $position, public readonly string $group = 'default')
    {
        $this->navigation = CmsTree::getNavigation($position, $group);
    }

    public function render()
    {
        return view('saas-cms::frontend.components.navigation');
    }
}