<?php

namespace Netzperfekt\SaasCms\View\Components;

use Illuminate\View\Component;
use Netzperfekt\SaasCms\Models\CmsTemplate;

class Template extends Component
{
    public $template = null;

    public function __construct(public readonly string $id)
    {
        $this->template = CmsTemplate::where('key', $id)->first();
        if( ! $this->template )
        {
            abort(403, 'Partial "' . $id . '" not found');
        }
    }

    public function render()
    {
        return view('saas-cms::frontend.components.template');
    }
}
