<?php

use Netzperfekt\SaasCms\Data\CmsGroupDefinition;
use Netzperfekt\SaasCms\Events\GetCmsGroupsEvent;
use Netzperfekt\SaasCms\Events\GetCmsLinkTypesEvent;

if (! function_exists('getCmsTypes')) {
    function getCmsTypes(): \Netzperfekt\SaasCms\Data\CmsTypeDefinition
    {
        $callbackResults = array_filter(event(new GetCmsLinkTypesEvent()));

        $types = [];
        $models = [];
        foreach($callbackResults as $result)
        {
            $types[$result['type']] = $result['label'];
            $models[$result['type']] = [
                'model' => $result['model'],
                'id'    => $result['modelid'],
                'name'  => $result['modelname']
            ];
        }

        return \Netzperfekt\SaasCms\Data\CmsTypeDefinition::from([
            'types'  => $types,
            'models' => $models
        ]);
    }
}

if (! function_exists('getCmsGroups'))
{
    function getCmsGroups(): CmsGroupDefinition
    {
        $groups = config('saas-cms.default-cms-groups', []);
        $positions = config('saas-cms.default-cms-positions', []);

        $tmpGroups = [];
        $tmpPositions = [];

        $callbackResults = array_filter(event(new GetCmsGroupsEvent()));
        $tenantGroups = [];

        foreach($callbackResults as $result)
        {
            $additionalGroups = $result->groups;
            $additionalPositions = $result->positions;
            $tenantGroups = array_merge($tenantGroups, $result->tenantGroups);

            foreach($additionalGroups as $groupKey => $groupLabel)
            {
                $tmpGroups[$groupKey] = $groupLabel;
                $tmpPositions[$groupKey] = $additionalPositions[$groupKey];
            }
        }

        return CmsGroupDefinition::from([
            'groups'       => array_merge($groups, $tmpGroups),
            'positions'    => array_merge($positions, $tmpPositions),
            'tenantGroups' => $tenantGroups
        ]);
    }
}
