export default function commentsFormComponent({ state, userId, userName, canEditOnlyOwnValues }) {
    const DATE_FORMAT = 'DD.MM.YYYY, HH:mm';

    return {
        state,

        rows: [],

        shouldUpdateRows: true,

        init: function ()
        {
            this.updateRows()

            if (this.rows.length <= 0)
            {
                // this.rows.push({ key: self.crypto.randomUUID(), value: { date: Date.now(), data: '', userId: userId, userName: userName } })
            }
            else {
                this.updateState()
            }

            this.$watch('state', (state, oldState) =>
            {
                const getLength = (value) =>
                {
                    if (value === null) {
                        return 0
                    }

                    if (Array.isArray(value)) {
                        return value.length
                    }

                    if (typeof value !== 'object') {
                        return 0
                    }

                    return Object.keys(value).length
                }

                if (getLength(state) === 0 && getLength(oldState) === 0) {
                    return
                }

                this.updateRows()
            })
        },

        addRow: function ()
        {
            let rows = this.rows
            const uuid = self.crypto.randomUUID()

            rows.push({
                key: uuid,
                value: {
                    date: Date.now(),
                    userId: userId,
                    userName: userName,
                    data: ''
                }
            })

            this.$nextTick(() =>
            {
                document.getElementById(`comment-${uuid}`).focus()
            });

            this.updateState()
            this.updateRows()
            this.$wire.$refresh()
        },

        toggleFull: function (showFull, uuid)
        {
            const inputEl = document.getElementById(`comment-full-${uuid}`);

            if(showFull)
            {
                setTimeout(() => {
                    inputEl.focus();
                }, 100);
            }

            return showFull;
        },

        deleteRow: function (index)
        {
            this.rows.splice(index, 1)

            // if (this.rows.length <= 0) {
            //     this.addRow()
            // }

            this.updateState()
        },

        updateRows: function ()
        {
            if ( ! this.shouldUpdateRows)
            {
                this.shouldUpdateRows = true

                return
            }

            let rows = []

            for (let [key, value] of Object.entries(this.state ?? {})) {
                rows.push({
                    key,
                    value,
                })
            }

            this.rows = this.sortRows(rows)
        },

        sortRows: function(rows)
        {
            return rows.sort(
                (a, b) => parseInt(b.value.date) - parseInt(a.value.date)
            )
        },

        updateState: function ()
        {
            let state = {}

            this.rows.forEach((row) => {
                if (row.key === '' || row.key === null) {
                    return
                }

                state[row.key] = row.value
            })

            // This is a hack to prevent the component from updating rows again
            // after a state update, which would otherwise be done by the `state`
            // watcher. If rows are updated again, duplicate keys are removed.
            //
            // https://github.com/filamentphp/filament/issues/1107
            this.shouldUpdateRows = false

            this.state = state
        },

        getDateFormatted: function(timestamp)
        {
            return window.moment.unix(parseInt(timestamp) / 1000).format(DATE_FORMAT)
        },

        updateDate: function(timestamp)
        {
            let newDate = timestamp

            do
            {
                let date = window.prompt(
                    'Datum eingeben',
                    window.moment.unix(parseInt(timestamp / 1000)).format(DATE_FORMAT)
                );

                if(date === null)
                {
                    return timestamp
                }

                newDate = window.moment(date, DATE_FORMAT)
            } while ( ! newDate.isValid())

            return (newDate.unix() * 1000).toString();
        }
    }
}
