@php
    use Filament\Support\Facades\FilamentView;

    $debounce = $getLiveDebounce();
    $hasInlineLabel = $hasInlineLabel();
    $isAddable = $isAddable();
    $isDeletable = $isDeletable();
    $isDisabled = $isDisabled();
    $statePath = $getStatePath();
@endphp

<x-dynamic-component
    :component="$getFieldWrapperView()"
    :field="$field"
    :has-inline-label="$hasInlineLabel"
>
    <x-slot
        name="label"
        @class([
            'sm:pt-1.5' => $hasInlineLabel,
        ])
    >
        {{ $getLabel() }}
    </x-slot>

    <x-filament::input.wrapper
        :disabled="$isDisabled"
        :valid="! $errors->has($statePath)"
        :attributes="
            \Filament\Support\prepare_inherited_attributes($getExtraAttributeBag())
                ->class(['fi-fo-comments'])
        "
    >
        <div
            @if (FilamentView::hasSpaMode())
                ax-load="visible"
            @else
                ax-load
            @endif
            ax-load-src="{{ \Filament\Support\Facades\FilamentAsset::getAlpineComponentSrc('comments-field', 'netzperfekt/saas-codoc') }}"
            wire:ignore
            x-data="commentsFormComponent({
                        state: $wire.{{ $applyStateBindingModifiers("\$entangle('{$statePath}')") }},
                        userId: '{{ $getUser()->id }}',
                        userName: '{{ $getUser()->name }}'
                    })"
            x-ignore
            {{
                $attributes
                    ->merge($getExtraAlpineAttributes(), escape: false)
                    ->class(['divide-y divide-gray-200 dark:divide-white/10'])
            }}
        >
            <table
                class="w-full table-auto divide-y divide-gray-200 dark:divide-white/5"
            >
                <thead>
                    <tr>
                        <th
                            scope="col"
                            class="px-3 py-2 text-start text-sm font-medium text-gray-700 dark:text-gray-200"
                        >
                            {{ $getKeyLabel() }}
                        </th>

                        <th
                            scope="col"
                            class="px-3 py-2 text-start text-sm font-medium text-gray-700 dark:text-gray-200"
                        >
                            {{ $getUserLabel() }}
                        </th>

                        <th
                            scope="col"
                            class="px-3 py-2 text-start text-sm font-medium text-gray-700 dark:text-gray-200"
                        >
                            {{ $getValueLabel() }}
                        </th>

                        @if ($isDeletable && (! $isDisabled))
                            <th
                                scope="col"
                                x-show="rows.length"
                                class="w-9"
                            ></th>
                        @endif
                    </tr>
                </thead>

                <tbody
                    class="divide-y divide-gray-200 dark:divide-white/5 bg-slate-100"
                >
                    <template
                        x-bind:key="index"
                        x-for="(row, index) in rows"
                    >
                        <tr class="divide-x divide-gray-200 dark:divide-white/5 rtl:divide-x-reverse hover:bg-slate-200"
                            x-data="{ showFull: false }"
                        >
                            <td class="w-1/5 p-0">
                                <div x-text="getDateFormatted(row.value.date)"
                                     @click.prevent
                                     @dblclick="if ( ! event.target.getAttribute('disabled')) { row.value.date = updateDate(row.value.date); $wire.$refresh(); }"
                                     x-bind:disabled="{{ $canEditValues() ? 'false' : 'true' }} || {{ $canEditOnlyOwnValues() ? 'true' : 'false' }} && row.value.userId != {{ $getUser()->id }}"
                                     class="ml-2 text-sm" />
                            </td>

                            <td class="w-1/5 p-0">
                                <div x-text="row.value.userName" class="ml-2 text-sm" />
                            </td>

                            <td class="w-3/5 p-0">
                                <x-filament::input
                                    type="text"
                                    class="font-semibold hover:bg-slate-300"
                                    :disabled="(! $canEditValues()) || $isDisabled"
                                    :placeholder="filled($placeholder = $getValuePlaceholder()) ? $placeholder : null"
                                    x-model="row.value.data"
                                    x-bind:id="`comment-${row.key}`"
                                    x-bind:disabled="{{ $canEditValues() ? 'false' : 'true' }} || {{ $canEditOnlyOwnValues() ? 'true' : 'false' }} && row.value.userId != {{ $getUser()->id }}"
                                    @keydown.meta.enter.prevent="showFull = ! showFull; toggleFull(showFull, row.key);"
                                    :attributes="
                                        \Filament\Support\prepare_inherited_attributes(
                                            new \Illuminate\View\ComponentAttributeBag([
                                                'x-on:input.debounce.' . ($debounce ?? '500ms') => 'updateState',
                                            ])
                                        )
                                    "
                                />

                                <x-filament::input.wrapper
                                        class="rounded-none"
                                        x-show="showFull"
                                        :disabled="$isDisabled"
                                        :valid="! $errors->has($statePath)"
                                        :attributes="
                                            \Filament\Support\prepare_inherited_attributes(
                                            new \Illuminate\View\ComponentAttributeBag([
                                                'x-on:input.debounce.' . ($debounce ?? '500ms') => 'updateState',
                                            ])
                                        )
                                        "
                                >
                                    <textarea
                                        type="textarea"
                                        class="showfull"
                                        x-model="row.value.datafull"
                                        x-bind:id="`comment-full-${row.key}`"
                                        @keydown.meta.enter.prevent="showFull = ! showFull; updateState()"
                                    ></textarea>
                                </x-filament::input.wrapper>
                            </td>

                            <td class="p-2" :class="row.value.datafull ? 'bg-info-200' : ''">
                                <x-filament::icon-button
                                    icon="heroicon-m-magnifying-glass"
                                    @click="showFull = ! showFull; toggleFull(showFull, row.key);"
                                    label="Zoom"
                                />
                            </td>

                            @if ($isDeletable && (! $isDisabled))
                                <td class="p-2">
                                    <div x-on:click="deleteRow(index)"
                                         x-show="{{ $canEditValues() ? 'true' : 'false' }} && ! ({{ $canEditOnlyOwnValues() ? 'true' : 'false' }} && row.value.userId != {{ $getUser()->id }})">
                                        {{ $getAction('delete') }}
                                    </div>
                                </td>
                            @endif
                        </tr>
                    </template>
                </tbody>
            </table>

            @if ($isAddable && (! $isDisabled))
                <div class="flex justify-center px-3 py-2">
                    <span x-on:click="addRow">
                        {{ $getAction('add') }}
                    </span>
                </div>
            @endif
        </div>
    </x-filament::input.wrapper>
</x-dynamic-component>
