@php
    use Filament\Support\Facades\FilamentView;

    $debounce = $getLiveDebounce();
    $hasInlineLabel = $hasInlineLabel();
    $statePath = $getStatePath();
@endphp

<x-dynamic-component
        :component="$getFieldWrapperView()"
        :field="$field"
        :has-inline-label="$hasInlineLabel"
>
    <x-slot
            name="label"
            @class([
                'sm:pt-1.5' => $hasInlineLabel,
            ])
    >
        {{ $getLabel() }}
    </x-slot>

    <x-filament::input.wrapper
            :disabled="$isDisabled"
            :valid="! $errors->has($statePath)"
    >
        <div
                @if (FilamentView::hasSpaMode())
                    ax-load="visible"
                @else
                    ax-load
                @endif
                ax-load-src="{{ \Filament\Support\Facades\FilamentAsset::getAlpineComponentSrc('dependency-field', 'netzperfekt/saas-codoc') }}"
                wire:ignore
                x-data="dependencyFormComponent({
                        state: $wire.{{ $applyStateBindingModifiers("\$entangle('{$statePath}')") }}
                    })"
                x-ignore
                x-init="initS3('container')"
                {{
                    $attributes
                        ->merge($getExtraAlpineAttributes(), escape: false)
                        ->class(['p-3'])
                }}
        >
            <div id="container" />
        </div>
    </x-filament::input.wrapper>
</x-dynamic-component>
