<x-filament-widgets::widget class="fi-account-widget">
    <x-filament::section>

        <div class="flex items-center gap-x-3">

            @if($startOnboarding)
                <div class="inline-flex space-x-2">
                    <x-filament::icon icon="heroicon-o-information-circle" class="mt-1 ms-3 h-10 w-10 text-blue-400 inline-block"/>

                    @include('saas-codoc::filament.widgets._doc', ['docId' => '0-docs', 'label' => 'Wie funktioniert BizCat?'])
                    @include('saas-codoc::filament.widgets._doc', ['docId' => 'organisations', 'label' => 'Was ist eine Organisation/ein Kontakt?'])
                    @include('saas-codoc::filament.widgets._doc', ['docId' => 'services', 'label' => 'Was ist ein Service/Dienst?'])
                    @include('saas-codoc::filament.widgets._doc', ['docId' => 'services-assignment', 'label' => 'Was ist eine Verknüpfung mit einem Service/Dienst?'])
                </div>
            @else
                <div class="flex-1">
                    <span class="grid flex-1 text-xl font-semibold text-gray-950 dark:text-white">
                        @if(count($todos) == 0)
                            <x-filament::icon icon="fas-check"
                                              class="h-10 w-10 text-green-500 inline-block" />
                            Inhalte: Alles in Ordnung!
                        @else
                            <x-filament::icon icon="fas-exclamation-triangle"
                                              class="h-10 w-10 text-red-500 inline-block" />
                            Achtung - bitte beachte folgende Punkte:
                        @endif
                    </span>

                    <div class="text-lg text-gray-500 dark:text-gray-400 mt-4 mb-8">
                        @forelse($todos as $todo)

                            <div class="flex mt-2">
                                <x-filament::badge color="danger" class="mr-2 w-8">
                                    {{ $todo['badge'] }}
                                </x-filament::badge>

                                <span class="font-semibold text-base text-red-500 mr-2">
                                    <a href="{{ $todo['linkUrl'] }}" class="hover:underline">
                                        {{ $todo['text'] }}
                                    </a>
                                </span>

                                    <x-filament::icon-button
                                            icon="fas-arrow-up-right-from-square"
                                            href="{{ $todo['linkUrl'] }}"
                                            tag="a"
                                            tooltip="{{ $todo['linkLabel'] }}"
                                            class="ml-auto"
                                    />
                            </div>

                        @empty

                        @endforelse
                    </div>
                </div>
            </div>
        @endif
    </x-filament::section>
</x-filament-widgets::widget>
