@if($assets && count($assets) > 0)
<div class="break-inside-avoid">
    <div class="mt-6 text-sm text-gray-600 font-bold">
        WIRTSCHAFTSGÜTER
    </div>

    <table class="table-auto border-separate border-spacing-y-2 text-sm text-left w-full">
        <thead class="text-left underline font-normal text-gray-400">
            <tr>
                <th></th>
                <th class="w-3/12">Bezeichnung</th>
                <th class="w-2/12">Hersteller &bull; Modell</th>
                <th class="w-3/12">S/N &bull; Inventar &bull; Standort</th>
                <th class="w-1/12">Kaufdatum</th>
                <th class="w-2/12">Typ</th>
                <th class="w-1/12">Status</th>
            </tr>
        </thead>

        <tbody>
            @foreach($assets as $asset)
                <tr class="align-top">
                    <td class="inline-block me-1 text-gray-400">
                        {{ $loop->iteration }}
                    </td>
                    <td class="w-3/12 font-semibold">
                        {{ $asset->title }}
                    </td>
                    <td class="w-2/12">
                        {{ $asset->manufacturer }}
                        &bull;
                        {{ $asset->model }}
                    </td>
                    <td class="w-3/12">
                        {{ $asset->serial_number }}
                        &bull;
                        {{ $asset->inventory_number }}
                        &bull;
                        {{ $asset->location }}
                    </td>
                    <td class="w-1/12">{{ $asset->buy_date->format('d.m.Y') }}</td>
                    <td class="w-2/12">{{ $asset->type->getLabel() }}</td>
                    <td class="w-1/12">{{ $asset->status->getLabel() }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endif
