@php
    $historyEntries = [];
    if(is_string($history)) {
        $historyEntries = json_decode($history);
    }
    else if(is_array($history)) {
        $historyEntries = $history;
    }
@endphp

@if($historyEntries && count($historyEntries) > 0)
<div class="break-inside-avoid">
    <div class="mt-6 text-sm text-gray-600 font-bold">
        HISTORIE / KOMMENTARE
    </div>

    <table class="table-auto border-separate border-spacing-y-2 text-sm text-left w-full">
        <thead class="text-left underline font-normal text-gray-400">
            <tr>
                <th class="w-3/12">Datum &bull; Benutzer</th>
                <th class="w-10/12">Anmerkung</th>
            </tr>
        </thead>

        <tbody>
            @foreach($historyEntries as $entry)
                <tr>
                    <td class="w-3/12">
                        {{ date('d.m.Y H:i', is_array($entry) ? (int)($entry['date'] ?? 0) / 1000 : (int)($entry->date ?? 0) / 1000) }}
                        &bull;
                        {{ is_array($entry) ? $entry['userName'] : ($entry->userName ?? '-') }}
                    </td>
                    <td class="w-9/12">
                        {!! is_array($entry) ? $entry['data'] : ($entry->data ?? '-')  !!}
                        <br>{!! is_array($entry) ? $entry['datafull'] ?? '' : ($entry->datafull ?? '') !!}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endif
